﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using Inet.Viewer.Data;
using Inet.Viewer.WinForms.Prompt;
namespace Inet.Viewer.test.WinForms
{
    [TestFixture]
    class TestRangePromptPanel
    {
        [Test]
        public void TestSimpleRange()
        {
            PromptData d = new PromptData("rangePrompt", null, null,
                new string[] { }, new string[] { }, PromptData.String, false, true,
                false, true, false, false, null, null, null);

            RangePromptField f = new RangePromptField(d);
            f.txtValueBoxFrom.Text = "ABC";
            f.txtValueBoxTo.Text = "DEF";
            f.chkIncludeTo.Checked = true;

            PromptValue pValue = f.Value;
            Assert.IsInstanceOf<RangePromptValue>(pValue);
            Assert.AreEqual("ABC", ((RangePromptValue)pValue).StartValue.ValueString);
            Assert.AreEqual("DEF", ((RangePromptValue)pValue).EndValue.ValueString);
        }
        [Test]
        public void TestReadsOutValue()
        {
            PromptData d = new PromptData("rangePrompt", null, null,
                new string[] { }, new string[] { }, PromptData.String, false, true,
                false, true, false, false, null, null, null);
            d.Values = new RangePromptValue(new SinglePromptValue("A", null, PromptData.String),
                new SinglePromptValue("B", null, PromptData.String), true, false, PromptData.String);

            RangePromptField f = new RangePromptField(d);
            Assert.AreEqual("A", f.txtValueBoxFrom.Text);
            Assert.AreEqual("B", f.txtValueBoxTo.Text);
            Assert.IsTrue(f.chkIncludeFrom.Checked);
            Assert.IsFalse(f.chkIncludeTo.Checked);
        }
    }
}
